// Big thanks to Loathsome for getting this to work online
// Give blood and splatters
class BloodDrop extends Blood2;

var() bool bDecal;

simulated function PostBeginPlay()
{
   Velocity.z += 30;
   if ( !Level.bDropDetail )
      Texture = MultiSkins[Rand(8)];
   Drawscale = FRand()*0.2+0.1;
   if (Level.NetMode != NM_DedicatedServer)
   {
      SpawnDrop();
   }
}

simulated function SpawnDrop()
{
   local Actor A;

   A = spawn(class'UT_BloodDrop');
   A.RemoteRole = ROLE_SimulatedProxy;
}

simulated function Landed( vector HitNormal )
{
   if (Level.NetMode != NM_DedicatedServer)
   {
      if ( bDecal )
      Spawn(class'BloodSplat',,,Location,rotator(HitNormal));
      Destroy();
   }
}

simulated function HitWall( vector HitNormal, actor Wall )
{
   if (Level.NetMode != NM_DedicatedServer)
   {
      if ( bDecal )
      Spawn(class'BloodSplat',,,Location,rotator(HitNormal));
      Destroy();
   }
}

defaultproperties
{
   bDecal=True
   bHighDetail=True
   Physics=PHYS_Falling
   LifeSpan=3.00
   DrawType=DT_Sprite
   Texture=Texture'Botpack.Blood.BD3'
   AmbientGlow=180
   MultiSkins(0)=Texture'Botpack.Blood.BD3'
   MultiSkins(1)=Texture'Botpack.Blood.BD4'
   MultiSkins(2)=Texture'Botpack.Blood.BD6'
   MultiSkins(3)=Texture'Botpack.Blood.BD9'
   MultiSkins(4)=Texture'Botpack.Blood.BD10'
   MultiSkins(5)=Texture'Botpack.Blood.BD3'
   MultiSkins(6)=Texture'Botpack.Blood.BD4'
   MultiSkins(7)=Texture'Botpack.Blood.BD6'
   bCollideWorld=True
   bBounce=True
   NetPriority=2.00
}
